within ApproxSpline;
package TestModels
  extends Modelica.Icons.Package;
  model Test001

    Real x;
    Real y0;
    Real y1;
    Real y2;
    Real y3;
    parameter Real data[:,:]=[
      0,10.5;
      1,10;
      2,11;
      3,12;
      4,13;
      5,12;
      6,11;
      7,10;
      8,9;
      9,9;
      10,9.1];

    parameter ApproxSpline.Curve1d.Type c0=
                      ApproxSpline.Curve1d.Type(
                                               data, s=0,k=1,x_lim={-1,12});
    parameter ApproxSpline.Curve1d.Type c1=
                      ApproxSpline.Curve1d.Type(
                                               data, s=1,k=3,x_lim={-1,12});
    parameter ApproxSpline.Curve1d.Type c2=
                      ApproxSpline.Curve1d.Type(
                                               data, s=0.01);
    parameter ApproxSpline.Curve1d.Type c3=
                      ApproxSpline.Curve1d.Type(
                                               data, s=0.1);
    Integer n0 = Curve1d.getNumberOfKnots(c0);
    Integer n1 = Curve1d.getNumberOfKnots(c1);
    Integer n2 = Curve1d.getNumberOfKnots(c2);
    Integer n3 = Curve1d.getNumberOfKnots(c3);

  equation
    x = 15*time-2.5;
    y0 =    Curve1d.eval(c0,x);
    y1 =    Curve1d.eval(c1,x);
    y2 =    Curve1d.eval(c2,x);
    y3 =    Curve1d.eval(c3,x);

  end Test001;

  model Test002

    import Modelica.Constants.pi;

    Real x;
    Real y0;

    Real y1;
    Real y2;
    Real y3;

    parameter Real data[:,:]=
  [0, 0;
  0.698131700797732, 0.642787609686539;
  1.39626340159546, 0.984807753012208;
  2.0943951023932, 0.866025403784439;
  2.79252680319093, 0.342020143325669;
  3.49065850398866, (-0.342020143325669);
  4.18879020478639, (-0.866025403784438);
  4.88692190558412, (-0.984807753012208);
  5.58505360638185, (-0.64278760968654);
  6.28318530717959, (-2.44929359829471e-016)];

    parameter ApproxSpline.Curve1d.Type c0=
                      ApproxSpline.Curve1d.Type(
                                               data=data, s=0,k=3,periodic=true);

    parameter ApproxSpline.Curve1d.Type c1=
                      ApproxSpline.Curve1d.Type(
                                               data=data, s=1,k=3,periodic=true);
    parameter ApproxSpline.Curve1d.Type c2=
                      ApproxSpline.Curve1d.Type(
                                               data=data, s=0.01,periodic=true);
    parameter ApproxSpline.Curve1d.Type c3=
                      ApproxSpline.Curve1d.Type(
                                               data, s=0.1,periodic=true);

    Integer n0 = Curve1d.getNumberOfKnots(c0);

    Integer n1 = Curve1d.getNumberOfKnots(c1);
    Integer n2 = Curve1d.getNumberOfKnots(c2);
    Integer n3 = Curve1d.getNumberOfKnots(c3);

  equation
    x = 3*2*pi*time;
    y0 =    Curve1d.eval(c0,x);
    y1 =    Curve1d.eval(c1,x);
    y2 =    Curve1d.eval(c2,x);
    y3 =    Curve1d.eval(c3,x);

  end Test002;

  model Test003
//    final parameter Integer N=100;

    parameter Real data[100,3] = {{0.0587785252292473,0.0809016994374948,0.888919506535624},{0.0951056516295154,0.0309016994374947,0.888919506535624},{0.0951056516295154,-0.0309016994374947,0.888919506535624},{0.0587785252292473,-0.0809016994374947,0.888919506535624},{1.22464679914735e-17,-0.1,0.888919506535624},{-0.0587785252292473,-0.0809016994374948,0.888919506535624},{-0.0951056516295154,-0.0309016994374948,0.888919506535624},{-0.0951056516295154,0.0309016994374947,0.888919506535624},{-0.0587785252292473,0.0809016994374947,0.888919506535624},{-2.44929359829471e-17,0.1,0.888919506535624},{0.117557050458495,0.16180339887499,0.760845213036123},{0.190211303259031,0.0618033988749895,0.760845213036123},{0.190211303259031,-0.0618033988749895,0.760845213036123},{0.117557050458495,-0.161803398874989,0.760845213036123},{2.44929359829471e-17,-0.2,0.760845213036123},{-0.117557050458495,-0.16180339887499,0.760845213036123},{-0.190211303259031,-0.0618033988749895,0.760845213036123},{-0.190211303259031,0.0618033988749895,0.760845213036123},{-0.117557050458495,0.161803398874989,0.760845213036123},{-4.89858719658941e-17,0.2,0.760845213036123},{0.176335575687742,0.242705098312484,0.623704566931857},{0.285316954888546,0.0927050983124842,0.623704566931857},{0.285316954888546,-0.0927050983124842,0.623704566931857},{0.176335575687742,-0.242705098312484,0.623704566931857},{3.67394039744206e-17,-0.3,0.623704566931857},{-0.176335575687742,-0.242705098312484,0.623704566931857},{-0.285316954888546,-0.0927050983124843,0.623704566931857},{-0.285316954888546,0.0927050983124842,0.623704566931857},{-0.176335575687742,0.242705098312484,0.623704566931857},{-7.34788079488412e-17,0.3,0.623704566931857},{0.235114100916989,0.323606797749979,0.485410196624968},{0.380422606518061,0.123606797749979,0.485410196624968},{0.380422606518061,-0.123606797749979,0.485410196624968},{0.235114100916989,-0.323606797749979,0.485410196624968},{4.89858719658941e-17,-0.4,0.485410196624968},{-0.235114100916989,-0.323606797749979,0.485410196624968},{-0.380422606518061,-0.123606797749979,0.485410196624968},{-0.380422606518061,0.123606797749979,0.485410196624968},{-0.235114100916989,0.323606797749979,0.485410196624968},{-9.79717439317883e-17,0.4,0.485410196624968},{0.293892626146237,0.404508497187474,0.353553390593274},{0.475528258147577,0.154508497187474,0.353553390593274},{0.475528258147577,-0.154508497187474,0.353553390593274},{0.293892626146237,-0.404508497187474,0.353553390593274},{6.12323399573677e-17,-0.5,0.353553390593274},{-0.293892626146237,-0.404508497187474,0.353553390593274},{-0.475528258147577,-0.154508497187474,0.353553390593274},{-0.475528258147577,0.154508497187474,0.353553390593274},{-0.293892626146237,0.404508497187474,0.353553390593274},{-1.22464679914735e-16,0.5,0.353553390593274},{0.352671151375484,0.485410196624968,0.235114100916989},{0.570633909777092,0.185410196624968,0.235114100916989},{0.570633909777092,-0.185410196624968,0.235114100916989},{0.352671151375484,-0.485410196624968,0.235114100916989},{7.34788079488412e-17,-0.6,0.235114100916989},{-0.352671151375484,-0.485410196624968,0.235114100916989},{-0.570633909777092,-0.185410196624969,0.235114100916989},{-0.570633909777092,0.185410196624968,0.235114100916989},{-0.352671151375484,0.485410196624968,0.235114100916989},{-1.46957615897682e-16,0.6,0.235114100916989},{0.411449676604731,0.566311896062463,0.136197149921864},{0.665739561406607,0.216311896062463,0.136197149921864},{0.665739561406608,-0.216311896062463,0.136197149921864},{0.411449676604731,-0.566311896062463,0.136197149921864},{8.57252759403147e-17,-0.7,0.136197149921864},{-0.411449676604731,-0.566311896062463,0.136197149921864},{-0.665739561406607,-0.216311896062463,0.136197149921864},{-0.665739561406608,0.216311896062463,0.136197149921864},{-0.411449676604731,0.566311896062463,0.136197149921864},{-1.71450551880629e-16,0.7,0.136197149921864},{0.470228201833978,0.647213595499958,0.0618033988749895},{0.760845213036123,0.247213595499958,0.0618033988749895},{0.760845213036123,-0.247213595499958,0.0618033988749895},{0.470228201833979,-0.647213595499958,0.0618033988749895},{9.79717439317882e-17,-0.8,0.0618033988749895},{-0.470228201833978,-0.647213595499958,0.0618033988749895},{-0.760845213036123,-0.247213595499958,0.0618033988749895},{-0.760845213036123,0.247213595499958,0.0618033988749895},{-0.470228201833979,0.647213595499958,0.0618033988749895},{-1.95943487863576e-16,0.8,0.0618033988749895},{0.529006727063226,0.728115294937453,0.0156434465040231},{0.855950864665638,0.278115294937453,0.0156434465040231},{0.855950864665638,-0.278115294937453,0.0156434465040231},{0.529006727063226,-0.728115294937453,0.0156434465040231},{1.10218211923262e-16,-0.9,0.0156434465040231},{-0.529006727063226,-0.728115294937453,0.0156434465040231},{-0.855950864665638,-0.278115294937453,0.0156434465040231},{-0.855950864665638,0.278115294937452,0.0156434465040231},{-0.529006727063226,0.728115294937453,0.0156434465040231},{-2.20436423846524e-16,0.9,0.0156434465040231},{0.587785252292473,0.809016994374947,3.14500586553911e-32},{0.951056516295153,0.309016994374947,3.14500586553911e-32},{0.951056516295154,-0.309016994374947,3.14500586553911e-32},{0.587785252292473,-0.809016994374947,3.14500586553911e-32},{1.22464679914735e-16,-1,3.14500586553911e-32},{-0.587785252292473,-0.809016994374947,3.14500586553911e-32},{-0.951056516295153,-0.309016994374948,3.14500586553911e-32},{-0.951056516295154,0.309016994374947,3.14500586553911e-32},{-0.587785252292473,0.809016994374947,3.14500586553911e-32},{-2.44929359829471e-16,1,3.14500586553911e-32}};
//    Real r;
    Real z[10];
//    Real phi;

//    import Modelica.Constants.pi;

    parameter ApproxSpline.Surf2d.Type s0 = ApproxSpline.Surf2d.Type(data=data, rectangular= false,s=5);

//    Integer k;

    Integer nx = ApproxSpline.Surf2d.getNumberOfKnotsX(s0);
    Integer ny = ApproxSpline.Surf2d.getNumberOfKnotsY(s0);

//  algorithm
//    k :=0;
//    r :=0;
//    for i in 0:9 loop
//      r :=r + 0.1;
//      phi :=0;
//      for j in 0:9 loop
//        k :=k + 1;
//        phi :=phi + 2*pi/10;
//        data[k,1] :=r*sin(phi);
//        data[k,2] :=r*cos(phi);
//        data[k,3] :=(1 - r)*cos(r*pi/2);
//      end for;
//    end for;

  equation

    for i in 1:10 loop
      z[i] = ApproxSpline.Surf2d.eval(s0, x=i/10, y=3*time-1.5);
    end for;

  end Test003;

  model Test006

    Blocks.Surf2d surf2d(data=[0.0587785252292473,0.0809016994374948,
          0.888919506535624; 0.0951056516295154,0.0309016994374947,
          0.888919506535624; 0.0951056516295154,(-0.0309016994374947),
          0.888919506535624; 0.0587785252292473,(-0.0809016994374947),
          0.888919506535624; 1.22464679914735E-017,(-0.1),0.888919506535624; (-0.0587785252292473),
          (-0.0809016994374948),0.888919506535624; (-0.0951056516295154),(-0.0309016994374948),
          0.888919506535624; (-0.0951056516295154),0.0309016994374947,
          0.888919506535624; (-0.0587785252292473),0.0809016994374947,
          0.888919506535624; (-2.44929359829471E-017),0.1,0.888919506535624;
          0.117557050458495,0.16180339887499,0.760845213036123;
          0.190211303259031,0.0618033988749895,0.760845213036123;
          0.190211303259031,(-0.0618033988749895),0.760845213036123;
          0.117557050458495,(-0.161803398874989),0.760845213036123;
          2.44929359829471E-017,(-0.2),0.760845213036123; (-0.117557050458495),
          (-0.16180339887499),0.760845213036123; (-0.190211303259031),(-0.0618033988749895),
          0.760845213036123; (-0.190211303259031),0.0618033988749895,
          0.760845213036123; (-0.117557050458495),0.161803398874989,
          0.760845213036123; (-4.89858719658941E-017),0.2,0.760845213036123;
          0.176335575687742,0.242705098312484,0.623704566931858;
          0.285316954888546,0.0927050983124842,0.623704566931858;
          0.285316954888546,(-0.0927050983124842),0.623704566931858;
          0.176335575687742,(-0.242705098312484),0.623704566931858;
          3.67394039744206E-017,(-0.3),0.623704566931858; (-0.176335575687742),
          (-0.242705098312484),0.623704566931858; (-0.285316954888546),(-0.0927050983124843),
          0.623704566931858; (-0.285316954888546),0.0927050983124842,
          0.623704566931858; (-0.176335575687742),0.242705098312484,
          0.623704566931858; (-7.34788079488412E-017),0.3,0.623704566931858;
          0.235114100916989,0.323606797749979,0.485410196624968;
          0.380422606518061,0.123606797749979,0.485410196624968;
          0.380422606518061,(-0.123606797749979),0.485410196624968;
          0.235114100916989,(-0.323606797749979),0.485410196624968;
          4.89858719658941E-017,(-0.4),0.485410196624968; (-0.235114100916989),
          (-0.323606797749979),0.485410196624968; (-0.380422606518061),(-0.123606797749979),
          0.485410196624968; (-0.380422606518061),0.123606797749979,
          0.485410196624968; (-0.235114100916989),0.323606797749979,
          0.485410196624968; (-9.79717439317883E-017),0.4,0.485410196624968;
          0.293892626146237,0.404508497187474,0.353553390593274;
          0.475528258147577,0.154508497187474,0.353553390593274;
          0.475528258147577,(-0.154508497187474),0.353553390593274;
          0.293892626146237,(-0.404508497187474),0.353553390593274;
          6.12323399573677E-017,(-0.5),0.353553390593274; (-0.293892626146237),
          (-0.404508497187474),0.353553390593274; (-0.475528258147577),(-0.154508497187474),
          0.353553390593274; (-0.475528258147577),0.154508497187474,
          0.353553390593274; (-0.293892626146237),0.404508497187474,
          0.353553390593274; (-1.22464679914735E-016),0.5,0.353553390593274;
          0.352671151375484,0.485410196624968,0.235114100916989;
          0.570633909777092,0.185410196624968,0.235114100916989;
          0.570633909777092,(-0.185410196624968),0.235114100916989;
          0.352671151375484,(-0.485410196624968),0.235114100916989;
          7.34788079488412E-017,(-0.6),0.235114100916989; (-0.352671151375484),
          (-0.485410196624969),0.235114100916989; (-0.570633909777092),(-0.185410196624969),
          0.235114100916989; (-0.570633909777092),0.185410196624968,
          0.235114100916989; (-0.352671151375484),0.485410196624968,
          0.235114100916989; (-1.46957615897682E-016),0.6,0.235114100916989;
          0.411449676604731,0.566311896062463,0.136197149921864;
          0.665739561406607,0.216311896062463,0.136197149921864;
          0.665739561406608,(-0.216311896062463),0.136197149921864;
          0.411449676604731,(-0.566311896062463),0.136197149921864;
          8.57252759403147E-017,(-0.7),0.136197149921864; (-0.411449676604731),
          (-0.566311896062463),0.136197149921864; (-0.665739561406607),(-0.216311896062463),
          0.136197149921864; (-0.665739561406608),0.216311896062463,
          0.136197149921864; (-0.411449676604731),0.566311896062463,
          0.136197149921864; (-1.71450551880629E-016),0.7,0.136197149921864;
          0.470228201833978,0.647213595499958,0.0618033988749895;
          0.760845213036123,0.247213595499958,0.0618033988749895;
          0.760845213036123,(-0.247213595499958),0.0618033988749895;
          0.470228201833979,(-0.647213595499958),0.0618033988749895;
          9.79717439317882E-017,(-0.8),0.0618033988749895; (-0.470228201833978),
          (-0.647213595499958),0.0618033988749895; (-0.760845213036123),(-0.247213595499958),
          0.0618033988749895; (-0.760845213036123),0.247213595499958,
          0.0618033988749895; (-0.470228201833979),0.647213595499958,
          0.0618033988749895; (-1.95943487863577E-016),0.8,0.0618033988749895;
          0.529006727063226,0.728115294937453,0.0156434465040231;
          0.855950864665638,0.278115294937453,0.0156434465040231;
          0.855950864665638,(-0.278115294937453),0.0156434465040231;
          0.529006727063226,(-0.728115294937453),0.0156434465040231;
          1.10218211923262E-016,(-0.9),0.0156434465040231; (-0.529006727063226),
          (-0.728115294937453),0.0156434465040231; (-0.855950864665638),(-0.278115294937453),
          0.0156434465040231; (-0.855950864665638),0.278115294937452,
          0.0156434465040231; (-0.529006727063226),0.728115294937453,
          0.0156434465040231; (-2.20436423846524E-016),0.9,0.0156434465040231;
          0.587785252292473,0.809016994374947,3.14500586553911E-032;
          0.951056516295153,0.309016994374947,3.14500586553911E-032;
          0.951056516295154,(-0.309016994374947),3.14500586553911E-032;
          0.587785252292473,(-0.809016994374947),3.14500586553911E-032;
          1.22464679914735E-016,(-1.0),3.14500586553911E-032; (-0.587785252292473),
          (-0.809016994374947),3.14500586553911E-032; (-0.951056516295153),(-0.309016994374948),
          3.14500586553911E-032; (-0.951056516295154),0.309016994374947,
          3.14500586553911E-032; (-0.587785252292473),0.809016994374947,
          3.14500586553911E-032; (-2.44929359829471E-016),1.0,
          3.14500586553911E-032], s=5)
      annotation (Placement(transformation(extent={{-20,20},{0,40}})));
    Modelica.Blocks.Sources.Clock clock
      annotation (Placement(transformation(extent={{-80,14},{-60,34}})));
    Modelica.Blocks.Sources.Constant const(k=0.5)
      annotation (Placement(transformation(extent={{-78,58},{-58,78}})));
  equation
    connect(clock.y, surf2d.u2) annotation (Line(
        points={{-59,24},{-22,24}},
        color={0,0,127}));
    connect(const.y, surf2d.u1) annotation (Line(
        points={{-57,68},{-40,68},{-40,36},{-22,36}},
        color={0,0,127}));
    annotation (Diagram(coordinateSystem(preserveAspectRatio=true, extent={{-100,
              -100},{100,100}})));
  end Test006;

  model MkPlotDataSurf2d
    extends ApproxSpline.Plot.plotDataSurf2d(
      s= 50,
      ky=2,
      data=
  {{10.000000,2.250000,0.966334},
   {20.000000,2.250000,0.965308},
   {30.000000,2.250000,0.963089},
   {40.000000,2.250000,0.960036},
   {50.000000,2.250000,0.955431},
   {60.000000,2.250000,0.950918},
   {70.000000,2.250000,0.948847},
   {80.000000,2.250000,0.946867},
   {90.000000,2.250000,0.944099},
   {10.000000,3.000000,0.955956},
   {20.000000,3.000000,0.952664},
   {30.000000,3.000000,0.949729},
   {40.000000,3.000000,0.946557},
   {50.000000,3.000000,0.941965},
   {60.000000,3.000000,0.937993},
   {70.000000,3.000000,0.934652},
   {80.000000,3.000000,0.931115},
   {10.000000,4.500000,0.944218},
   {20.000000,4.500000,0.933221},
   {30.000000,4.500000,0.922891},
   {40.000000,4.500000,0.912024},
   {50.000000,4.500000,0.900083},
   {60.000000,4.500000,0.888309}});

  end MkPlotDataSurf2d;

  model MkPlotDataCurve1d
    extends ApproxSpline.Plot.plotDataCurve1d(
      s= 0.1,
  data=
  {{10.000000,0.97},
   {20.000000,0.97},
   {30.000000,0.96},
   {40.000000,0.96},
   {50.000000,0.96},
   {60.000000,0.95},
   {70.000000,0.95},
   {80.000000,0.95},
   {90.000000,0.94}});
  /*
    data=
{{10.000000,0.966334},
 {20.000000,0.965308},
 {30.000000,0.963089},
 {40.000000,0.960036},
 {50.000000,0.955431},
 {60.000000,0.950918},
 {70.000000,0.948847},
 {80.000000,0.946867},
 {90.000000,0.944099}}
*/

  end MkPlotDataCurve1d;

  model MkPlotDataCurve1dPeriodic
    extends ApproxSpline.Plot.plotDataCurve1d(
      periodic=true,
      n=100,
      s= 1e-6,
      data=
  {{1.000000,0.966334},
   {2.000000,0.965308},
   {3.000000,0.963089},
   {4.000000,0.960036},
   {5.000000,0.955431},
   {6.000000,0.950918},
   {7.000000,0.948847},
   {8.000000,0.946867},
   {9.000000,0.944099},
  {10.000000,0.946867},
  {11,0.955431}});

  /*
[0, 0;
0.698131700797732, 0.642787609686539;
1.39626340159546, 0.984807753012208;
2.0943951023932, 0.866025403784439;
2.79252680319093, 0.342020143325669;
3.49065850398866, (-0.342020143325669);
4.18879020478639, (-0.866025403784438);
4.88692190558412, (-0.984807753012208);
5.58505360638185, (-0.64278760968654);
6.28318530717959, (-2.44929359829471e-016)],
*/

  end MkPlotDataCurve1dPeriodic;

  model MkPlotMinCellVoltage
    extends ApproxSpline.Plot.plotDataCurve1d(
      n=500,
      s= 7e-4,
      filename = "cellVoltage_s=7e-4.mat",
      data=
  {{1.000000,0.880000},
   {1.300000,0.880000},
   {1.400000,0.870000},
   {1.500000,0.880000},
   {1.600000,0.880000},
   {1.700000,0.890000},
   {1.800000,0.930000},
   {1.900000,0.940000},
   {2.000000,0.940000},
   {2.100000,0.950000},
   {2.200000,0.950000},
   {2.300000,0.960000},
   {2.400000,0.960000},
   {2.500000,0.960000},
   {2.600000,0.960000},
   {2.700000,0.960000},
   {2.800000,0.960000},
   {2.900000,0.970000},
   {3.000000,0.970000},
   {1.100000,0.880000},
   {1.200000,0.880000}});

  /*
{{0.000000,0.880000},
 {0.100000,0.880000},
 {0.200000,0.880000},
 {0.300000,0.880000},
 {0.400000,0.880000},
 {0.500000,0.880000},
 {0.600000,0.880000},
 {0.700000,0.880000},
 {0.800000,0.880000},
 {0.900000,0.880000},
 {1.000000,0.880000},
 {1.100000,0.880000},
 {1.200000,0.880000},
 {1.300000,0.880000},
 {1.400000,0.870000},
 {1.500000,0.880000},
 {1.600000,0.880000},
 {1.700000,0.890000},
 {1.800000,0.930000},
 {1.900000,0.940000},
 {2.000000,0.940000},
 {2.100000,0.950000},
 {2.200000,0.950000},
 {2.300000,0.960000},
 {2.400000,0.960000},
 {2.500000,0.960000},
 {2.600000,0.960000},
 {2.700000,0.960000},
 {2.800000,0.960000},
 {2.900000,0.970000},
 {3.000000,0.970000},
 {3.100000,0.970000},
 {3.200000,0.970000},
 {3.300000,0.970000},
 {3.400000,0.970000},
 {3.500000,0.970000},
 {3.600000,0.970000},
 {3.700000,0.970000},
 {3.800000,0.970000},
 {3.900000,0.970000},
 {4.000000,0.970000},
 {4.100000,0.980000},
 {4.200000,0.980000},
 {4.300000,0.980000},
 {4.400000,0.980000},
 {4.500000,0.980000},
 {4.600000,0.980000},
 {4.700000,0.980000},
 {4.800000,0.980000},
 {4.900000,0.980000},
 {5.000000,0.980000},
 {5.100000,0.980000},
 {5.200000,0.980000},
 {5.300000,0.980000},
 {5.400000,0.980000},
 {5.500000,0.980000},
 {5.600000,0.980000},
 {5.700000,0.980000},
 {5.800000,0.980000},
 {5.900000,0.980000},
 {6.000000,0.980000},
 {6.100000,0.980000},
 {6.200000,0.980000},
 {6.300000,0.980000},
 {6.400000,0.980000},
 {6.500000,0.990000},
 {6.600000,0.990000},
 {6.700000,0.990000},
 {6.800000,0.990000},
 {6.900000,0.990000},
 {7.000000,0.990000},
 {7.100000,0.990000},
 {7.200000,0.990000},
 {7.300000,0.990000},
 {7.400000,0.990000},
 {7.500000,0.990000},
 {7.600000,0.990000},
 {7.700000,0.990000},
 {7.800000,0.990000},
 {7.900000,0.990000},
 {8.000000,0.990000}}
*/

  end MkPlotMinCellVoltage;

  model MkPlotFuelCellSystemEfficiency
    extends ApproxSpline.Plot.plotDataCurve1d(
      n=500,
      s= 0.0,
      filename = "fuelCellSystemEfficiency_s=0.0.mat",
      data=
  {{2.500000,26.42},
   {7.500000,41.04},
   {12.500000,46.17},
   {17.500000,50.41},
   {22.500000,52.59},
   {27.500000,52.59},
   {32.500000,52.27},
   {37.500000,54.10},
   {42.500000,53.02},
   {47.500000,51.80},
   {52.500000,52.92},
   {57.500000,50.97},
   {62.500000,48.69},
   {67.500000,49.83},
   {72.500000,48.80},
   {77.500000,47.89},
   {82.500000,46.63},
   {87.500000,47.01},
   {92.500000,46.03},
   {97.500000,44.37}});
  /*
{{2.500000,26.424875},
 {7.500000,41.036297},
 {12.500000,46.167678},
 {17.500000,50.407227},
 {22.500000,52.589180},
 {27.500000,52.585690},
 {32.500000,52.274637},
 {37.500000,54.096312},
 {42.500000,53.019704},
 {47.500000,51.803715},
 {52.500000,52.915169},
 {57.500000,50.972618},
 {62.500000,48.693847},
 {67.500000,49.833963},
 {72.500000,48.799329},
 {77.500000,47.889932},
 {82.500000,46.632677},
 {87.500000,47.014706},
 {92.500000,46.027640},
 {97.500000,44.368679}}
*/

  end MkPlotFuelCellSystemEfficiency;
  annotation(Icon(graphics={
            Polygon(
                points={{-70,0},{-44,0},{-24,-34},{50,56},{78,56},{-24,
                -74},{-70,0}},
                lineColor={75,138,73},
                fillColor={75,138,73},
                fillPattern=FillPattern.Solid)}));
end TestModels;
